/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.entity;

import net.brdle.collectorsreap.common.entity.ChieftainCrab;
import net.brdle.collectorsreap.common.entity.Clam;
import net.brdle.collectorsreap.common.entity.PlatinumBass;
import net.brdle.collectorsreap.common.entity.ThrownShimmeringPearl;
import net.brdle.collectorsreap.common.entity.TigerPrawn;
import net.brdle.collectorsreap.common.entity.Urchin;
import net.brdle.collectorsreap.common.entity.UrchinDart;
import net.brdle.collectorsreap.common.entity.WaterGroundCreature;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="collectorsreap", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CREntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"collectorsreap");
    public static final RegistryObject<EntityType<TigerPrawn>> TIGER_PRAWN = CREntities.reg("tiger_prawn", TigerPrawn::new, MobCategory.WATER_AMBIENT, 0.8f, 0.4f);
    public static final RegistryObject<EntityType<Urchin>> URCHIN = CREntities.reg("urchin", Urchin::new, MobCategory.WATER_AMBIENT, 0.5f, 0.5f);
    public static final RegistryObject<EntityType<PlatinumBass>> PLATINUM_BASS = CREntities.reg("platinum_bass", PlatinumBass::new, MobCategory.WATER_AMBIENT, 1.2f, 0.5f);
    public static final RegistryObject<EntityType<Clam>> CLAM = CREntities.reg("clam", Clam::new, MobCategory.WATER_AMBIENT, 1.0f, 0.5f);
    public static final RegistryObject<EntityType<ChieftainCrab>> CHIEFTAIN_CRAB = CREntities.reg("chieftain_crab", ChieftainCrab::new, MobCategory.WATER_AMBIENT, 0.85f, 0.65f);
    public static final RegistryObject<EntityType<UrchinDart>> URCHIN_DART = ENTITY_TYPES.register("urchin_dart", () -> EntityType.Builder.m_20704_(UrchinDart::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).m_20712_("collectorsreap.urchin_dart"));
    public static final RegistryObject<EntityType<ThrownShimmeringPearl>> SHIMMERING_PEARL = ENTITY_TYPES.register("shimmering_pearl", () -> EntityType.Builder.m_20704_(ThrownShimmeringPearl::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_("collectorsreap.shimmering_pearl"));

    private static <T extends Entity> RegistryObject<EntityType<T>> reg(String name, EntityType.EntityFactory<T> fact, MobCategory category, float width, float height) {
        return ENTITY_TYPES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)fact, (MobCategory)category).m_20699_(width, height).m_20712_("collectorsreap." + name));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)TIGER_PRAWN.get(), TigerPrawn.createAttributes().m_22265_());
        event.put((EntityType)URCHIN.get(), Urchin.createAttributes().m_22265_());
        event.put((EntityType)PLATINUM_BASS.get(), PlatinumBass.createAttributes().m_22265_());
        event.put((EntityType)CLAM.get(), Clam.createAttributes().m_22265_());
        event.put((EntityType)CHIEFTAIN_CRAB.get(), ChieftainCrab.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerEntitySpawnPlacements(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)PLATINUM_BASS.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)TIGER_PRAWN.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)URCHIN.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterGroundCreature::checkWaterGroundSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)CLAM.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterGroundCreature::checkWaterGroundSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
        event.register((EntityType)CHIEFTAIN_CRAB.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ChieftainCrab::checkCrabSpawnRules, SpawnPlacementRegisterEvent.Operation.AND);
    }

    public static void create(IEventBus bus) {
        ENTITY_TYPES.register(bus);
    }
}

